﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using System.Runtime.InteropServices;
using Telerik.Web.UI;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class InstrumentEvaluationEntry : BaseTBIInstrumentPage
{
    #region Variable Declarations

    private const string FailedFormValuesName = "CTBIEFailedFormValues";
    private const string DeferredMessageKeyName = "CTBIEDeferredMessageKey";
    PatientManager pManager = new PatientManager();
    int surveyTypeId = 2; 
    SURVEY evalSurvey;
    public delegate void MasterPageMenuClickHandler(object sender, MenuEventArgs e);
    public event MasterPageMenuClickHandler MenuClick;
    #endregion

    #region Public Methods
    protected void Menu2_MenuItemClick(object sender, MenuEventArgs e)
    {
        if (MenuClick != null)
        {
            MenuClick(sender, e);
        }
    }

    public InstrumentEvaluationEntry()
    {
        //Manager Save Notification Event Handler
        pManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #endregion

    #region Protected Methods

    protected void Page_Init(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(_tbiInstrumentManager, surveyTypeId);
    }

    protected void Page_Unload(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(null, -1);
    }

    bool preventNotification = false;
    protected void Page_PreRenderComplete(object sender, EventArgs e)
    {
        Dictionary<string, string> cache;
        //if (!Page.IsPostBack && Helpers.SetupPageFromCache(this, FailedFormValuesName, out cache))
        //{
        //    SuppressSaveMessage = false;
        //    SaveFailMessage = "Unable to save the survey.\r\n\r\nThere may be network issues preventing you from saving.\r\n\r\nPlease try to submit your changes again.";
        //    RenderStartUpMessage(false);
        //}
        //else 
            
        if (Page.IsPostBack && !preventNotification)
        {
            DeferredMessage = "Save was Successful!";
        }
        else if (DeferredMessage != null)
        {
            SuppressSaveMessage = false;
            SaveSuccessMessage = DeferredMessage;
            RenderStartUpMessage(true);
            DeferredMessage = null;
        }
    }

    private static string DeferredMessage
    {
        get { return HttpContext.Current.Session[DeferredMessageKeyName] as string; }
        set { HttpContext.Current.Session[DeferredMessageKeyName] = value; }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            _tbiInstrumentManager.TbiServiceTo = base.GetTBIServiceTo();
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("InstrumentEvaluationEntry.Page_Load(): _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }
            if (!IsPostBack)
            {
                //turn off viewstate for all radiobuttonlists
                this.GetAllControls().OfType<RadioButtonList>().ToList().ForEach(c => c.EnableViewState = false);

                //These are DataBound controls and need viewstate
               // rblMedicationReconciliationPerformed.EnableViewState = true;  //DEBUG(ETM) Check on these commented out lines
                //rblMedicationGiven.EnableViewState = true;  //DEBUG(ETM) Check on these commented out lines

                //rblMedicationReconciliationPerformed.Attributes["onclick"] = "rblMedicationReconciliationPerformed_CheckChanged()"; //DEBUG(ETM) Check on these commented out lines
                //ScriptManager.RegisterStartupScript(this, this.GetType(), "rblMedicationReconciliationPerformed_CheckChanged", "rblMedicationReconciliationPerformed_CheckChanged()", true); //DEBUG(ETM) Check on these commented out lines

                //LoadRadioButtonListItems(rblMedicationReconciliationPerformed, "21-A");  //DEBUG(ETM) Check on these commented out lines
                //LoadRadioButtonListItems(rblMedicationGiven, "21-B");  //DEBUG(ETM) Check on these commented out lines

                string _snum = string.Empty;

                base.AddtoViewStateTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);
                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                if (labelUser != null)
                {
                    labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);
                }

                if (!string.IsNullOrEmpty(_snum))
                {
                    string patICN = pManager.GetPatientICNBySnum(_snum);
                    if (!string.IsNullOrEmpty(patICN))
                    {
                        ViewState["PatientICN"] = patICN;
                        getRefreshEvalSurvey(patICN);
                    }
                    else
                    {
                        throw new ArgumentException("Patient with this SSN does not exist.");
                    }
                    string referrer = "";
                    if (Request.UrlReferrer != null)
                    {
                        referrer = Request.UrlReferrer.PathAndQuery;
                    }
                    ViewState["referrer"] = referrer;
                    if (evalSurvey != null)
                    {
                        if (evalSurvey.isNew)
                        {
                            SetDefaultValues();
                        }
                        else
                        {
                            SetUpEvalSurvey(evalSurvey);
                        }
                    }
                }
                InjuryYearRangeValidator.MinimumValue = "2001";
                InjuryYearRangeValidator.MaximumValue = DateTime.Today.Year.ToString();
                SecondInjuryYearRangeValidator.MinimumValue = "2001";
                SecondInjuryYearRangeValidator.MaximumValue = DateTime.Today.Year.ToString();
                LeastInjuryYearRangeValidator.MinimumValue = "2001";
                LeastInjuryYearRangeValidator.MaximumValue = DateTime.Today.Year.ToString();
                bool enabledState = false;
                if (evalSurvey != null)
                {
                    enabledState = String.IsNullOrEmpty(evalSurvey.SURVEY_STATUS) || evalSurvey.SURVEY_STATUS.ToLower() != "completed";
                }
                SaveButton.Enabled = SavePrepareNoteButton.Enabled = enabledState;
            }
        }
        catch (Exception ex2)
        {
            Exception _tbilogerror = HandleTBIException(ex2, "InstrumentEvaluationEntry.aspx", "100029", "Page_Load()");
            //Redirect to message that session is ended and need to log back in from CPRS.
            Response.Redirect("Warning.aspx?err=2");
        }
    }

    private void LoadRadioButtonListItems(RadioButtonList rbl, string questionNumber)
    {
        List<STD_QUESTION_CHOICE> list = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
        list.RemoveAt(0);
        rbl.DataSource = list;
        rbl.DataBind();
    }

    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        evalSurvey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState()
    {
        ViewState["surveyXml"] = evalSurvey.Serialize();
        return base.SaveViewState();
    }

    protected void SaveSurvey_Click(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Succeeded";
        SaveCompleteSurvey(ref status);
        Response.Redirect(Request.Url.PathAndQuery, false);
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void CancelSurvey_Click(object sender, EventArgs e)
    {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
    }

    protected void SavePrepareNote_Click(object sender, EventArgs e)
    {
        try
        {
            Int32 status = 0;
            SaveFailMessage = "Save Successful";
            SaveCompleteSurvey(ref status);
            if (status > 0)
            {
                preventNotification = true;
                Session["survey"] = evalSurvey;
                Response.Redirect("InstrumentSummaryNote.aspx", false);
            }
            else
            {
                Response.Redirect(Request.Url.PathAndQuery, false);
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentEvaluationEntry.aspx", "100029", "SavePrepareNote_Click()");
        }
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e)
    {
        preventNotification = true;
        Logging.WriteLogToFile("InstrumentEvaluationEntry.InActiveTimer_Tick");
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + SaveButton.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        Response.Redirect(Request.Url.PathAndQuery, false);
    }

    #endregion

    #region Private Methods

    private void getRefreshEvalSurvey(string patientICN)
    {
        try
        {
            var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, surveyTypeId, false).ToList();
            if (surveys.Count > 0)
            {
                evalSurvey = surveys.First();
            }
            else
            {
                evalSurvey = new SURVEY();
            }
            evalSurvey.SetAsChangeTrackingRoot();
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentEvaluationEntry.aspx", "100029", "getRefreshEvalSurvey()");
        }
    }

    private void SaveCompleteSurvey(ref Int32 status)
    {
        Logging.WriteLogToFile("InstrumentEvaluationEntry.SaveCompleteSurvey");
        string patientICN = String.Empty;
        status = 0;
        try
        {
            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null)
            {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("InstrumentEvaluationEntry.SaveCompeletedSurvey(): WarningRedirect: ViewState[PatientICN]");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("InstrumentEvaluationEntry.SaveCompeletedSurvey(): WarningRedirect: ViewState[PatientICN]");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2", false);
            }

            if (evalSurvey.isNew)
            {
                Logging.WriteLogToFile("InstrumentEvaluationEntry.SaveCompletedSurvey().evalSurvey.isNew");
                //Ensure that a concurrent session hasn't already inserted a record for this survey
                var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, surveyTypeId, true).ToList();
                if (surveys.Count > 0)
                {
                    Logging.WriteLogToFile("InstrumentEvaluationEntry.SaveCompeletedSurvey(): WarningRedirect: surveys.Count > 0");
                    //A concurrent session has already inserted a record for this survey and it is not new anymore.
                    Response.Redirect("Warning.aspx?err=9", false);
                }
                else
                {
                    evalSurvey.SURVEY_STATUS = "inprocess";
                    evalSurvey.SetAsInsertOnSubmit();
                    evalSurvey.patient_ICN = patientICN;
                    evalSurvey.STD_SURVEY_TYPE_ID = surveyTypeId;
                    evalSurvey.SURVEY_DATE = DateTime.Today;
                    //Save survey if it's new before adding any responses
                    _tbiInstrumentManager.Update(evalSurvey);
                    getRefreshEvalSurvey(patientICN);
                }
            }
            SaveSurvey(ref evalSurvey);
            evalSurvey.SetAsUpdateOnSubmit();
            status = _tbiInstrumentManager.Update(evalSurvey);
            if (status != 0)
            {
                //Fortify errors on this line (this.Master as RegistryInstrumentMaster).SetDirtyFlag(false);
                ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);
                getRefreshEvalSurvey(patientICN);
                SuppressSaveMessage = false;
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentEvaluationEntry.aspx", "100029", "SaveCompleteSurvey()");
        }
        finally
        {
            if (status == 0)
                Helpers.SavePageToCache(this, FailedFormValuesName);
            else
                Session[FailedFormValuesName] = null;//clear out the cached version on success
        }
    }

    #region SaveSurvey

    private bool RadioHasValue(RadioButtonList radio, params string[] values)
    {
        if (null == radio)
            throw new ArgumentException("A valid radio button list must be provided", "radio");
        if (null == values || values.Length == 0)
            return false;
        foreach (string s in values)
        {
            if (s == radio.SelectedValue)
                return true;
        }
        return false;
    }

    private List<STD_QUESTION_CHOICE> GetQuestionChoices(string questionNumber)
    {
        return VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
    }

    private void SaveFreeText(SURVEY survey, List<STD_QUESTION> questions, string questionNumber, TextBox textBox, bool excludeResult)
    {
        List<STD_QUESTION_CHOICE> _list = GetQuestionChoices(questionNumber);
        SURVEY_RESULT inputResult = new SURVEY_RESULT();
        string sVal = textBox.Text.Trim();
        if (!String.IsNullOrEmpty(sVal)) { inputResult.RESULT_TEXT = sVal; }
        if (excludeResult)
        {
            inputResult.STD_QUESTION_CHOICE_ID = _list.FirstOrDefault(item => item.CHOICE_SORT_ORDER == null).STD_QUESTION_CHOICE_ID; //_list[0].STD_QUESTION_CHOICE_ID 
        }
        else
        {
            inputResult.STD_QUESTION_CHOICE_ID = _list.FirstOrDefault(item => item.CHOICE_SORT_ORDER != null).STD_QUESTION_CHOICE_ID; //_list[0].STD_QUESTION_CHOICE_ID 
        }
        SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => _list.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
        SaveGeneric(survey, inputResult, currentResult, questionNumber);
    }

    private void SaveGeneric(SURVEY survey, SURVEY_RESULT inputResult, SURVEY_RESULT currentResult, string questionNumber)
    {
        if (currentResult == null)
        {
            survey.SURVEY_RESULTs.Add(inputResult);
        }
        else if (currentResult.STD_QUESTION_CHOICE_ID != inputResult.STD_QUESTION_CHOICE_ID || currentResult.RESULT_TEXT != inputResult.RESULT_TEXT)
        {
            //currentResult.SetAsDeleteOnSubmit();
            survey.SURVEY_RESULTs.Add(inputResult);
        }
        else
        {
            currentResult.SetAsNoChangeOnSubmit();
            System.Diagnostics.Debug.WriteLine("No update required for question " + questionNumber);
        }
    }

    private void SaveMultiSelect(SURVEY survey, List<STD_QUESTION> questions, string questionNumber, ListItemCollection checkBoxItems, bool addNullCondition)
    {
        List<STD_QUESTION_CHOICE> _list = _tbiInstrumentManager.GetChoicesByQuestionNumberandSurveyType(questionNumber, "COMP TBI EVAL");
        survey.SURVEY_RESULTs.OrderBy("STD_QUESTION_CHOICE_ID");
        SURVEY_RESULT[] currentResults = survey.SURVEY_RESULTs.Where(item => _list.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null).ToArray();
        int selectedItems = 0;
        foreach (ListItem item in checkBoxItems)
        {
            int i = Convert.ToInt32(item.Value);
            
            var selection = currentResults.Where(c => c.STD_QUESTION_CHOICE_ID == _list[i].STD_QUESTION_CHOICE_ID).FirstOrDefault();
            if (item.Selected)
            {
                selectedItems++;
                if (selection != null)
                {
                    //found it so it was here and no need to add it
                    selection.SetAsNoChangeOnSubmit();
                }
                else
                {
                    //have not found it so need to add it.
                    SURVEY_RESULT result = new SURVEY_RESULT() { STD_QUESTION_CHOICE_ID = _list[int.Parse(item.Value)].STD_QUESTION_CHOICE_ID };
                    survey.SURVEY_RESULTs.Add(result);
                }
            }
            //else it is already marked for deletion if it exists
        }
        if (selectedItems == 0)
        {
            if (addNullCondition)
            {
                SURVEY_RESULT result = new SURVEY_RESULT() { STD_QUESTION_CHOICE_ID = _list[0].STD_QUESTION_CHOICE_ID };
                survey.SURVEY_RESULTs.Add(result);
            }
        }
        //the null one is already marked for deletion so nothing else to do
    }

    private bool IsNotAsked(string s)
    {
        if (string.IsNullOrEmpty(s))
            return false;
        return s.IndexOf("not asked", StringComparison.OrdinalIgnoreCase) != -1;
    }

    private void SaveSingleSelect(SURVEY survey, List<STD_QUESTION> questions, string questionNumber, RadioButtonList radioButtonList, bool omitAsNull)
    {
        List<STD_QUESTION_CHOICE> _list = GetQuestionChoices(questionNumber);
        SURVEY_RESULT inputResult = BuildInputResult(radioButtonList, _list, omitAsNull);
        if (null == inputResult || IsNotAsked(inputResult.RESULT_TEXT))
            return;//just allow the item to be deleted
        SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => _list.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
        SaveGeneric(survey, inputResult, currentResult, questionNumber);
    }

    private SURVEY_RESULT BuildInputResult(RadioButtonList radioButtonList, List<STD_QUESTION_CHOICE> choices, bool omitAsNull)
    {
        SURVEY_RESULT result = new SURVEY_RESULT();
        STD_QUESTION_CHOICE tempChoice = null;
        if (omitAsNull)
        {
            tempChoice = choices.FirstOrDefault(item => item.CHOICE_SORT_ORDER == null);
        }
        else if (radioButtonList.SelectedIndex > -1)
        {
            tempChoice = choices.FirstOrDefault(item => item.CHOICE_SORT_ORDER == radioButtonList.SelectedIndex + 1);
        }
        else
        {
            return null;
        }
        result.STD_QUESTION_CHOICE_ID = tempChoice.STD_QUESTION_CHOICE_ID;
        result.RESULT_TEXT = tempChoice.CHOICE_TEXT;
        return result;
    }

    private List<SURVEY_RESULT> allDBResults = null;
    private List<SURVEY_RESULT> AllDBResults
    {
        get
        {
            if (allDBResults == null)
                allDBResults = _tbiInstrumentManager.GetChoicesBySurveyID(evalSurvey.SURVEYS_ID);
            return allDBResults;
        }
    }

    private void SaveSurvey(ref SURVEY survey)
    {
        Logging.WriteLogToFile("InstrumentEvaluationEntry.SaveSurvey");
        string questionNumber = "START";
        try
        {
            survey.SetAsChangeTrackingRoot();
            foreach (SURVEY_RESULT result in survey.SURVEY_RESULTs)
                result.SetAsDeleteOnSubmit();
            List<STD_QUESTION> questions = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestions();
            SaveSingleSelect(survey, questions, "A", rbnonVAProvider, false);
            if (rbnonVAProvider.SelectedValue != "1")
            {
                SaveSingleSelect(survey, questions, questionNumber = "1", rbMaritalStatus, false);
                SaveSingleSelect(survey, questions, questionNumber = "2", rbEducationalLevel, false);
                SaveSingleSelect(survey, questions, questionNumber = "3", rbEmploymentStatus, false);
                SaveSingleSelect(survey, questions, questionNumber = "4", rbInjuriesQuantity, false);
                if(rbInjuriesQuantity.SelectedIndex>0)
                { 
                    switch (rbInjuriesQuantity.SelectedIndex.ToString())
                    {
                        case "1":
                            SaveFreeText(survey, questions, questionNumber = "4-A-1", InjuryMonthTextBox, false);
                            SaveFreeText(survey, questions, questionNumber = "4-A-2", InjuryYearTextBox, false);
                            break;
                        case "2":
                            SaveFreeText(survey, questions, questionNumber = "4-A-1", InjuryMonthTextBox, false);
                            SaveFreeText(survey, questions, questionNumber = "4-A-2", InjuryYearTextBox, false);
                            SaveFreeText(survey, questions, questionNumber = "4-B-1", SecondInjuryMonthTextBox, false);
                            SaveFreeText(survey, questions, questionNumber = "4-B-2", SecondInjuryYearTextBox, false);
                            break;
                        case "3":
                            SaveFreeText(survey, questions, questionNumber = "4-A-1", InjuryMonthTextBox, false);
                            SaveFreeText(survey, questions, questionNumber = "4-A-2", InjuryYearTextBox, false);
                            SaveFreeText(survey, questions, questionNumber = "4-B-1", SecondInjuryMonthTextBox, false);
                            SaveFreeText(survey, questions, questionNumber = "4-B-2", SecondInjuryYearTextBox, false);
                            SaveFreeText(survey, questions, questionNumber = "4-C-1", LeastInjuryMonthTextBox, false);
                            SaveFreeText(survey, questions, questionNumber = "4-C-2", LeastInjuryYearTextBox, false);
                            break;
                            
                    }
                
                SaveSingleSelect(survey, questions, questionNumber = "6", rbSixSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "6-A", rbSixASection, false); 
                SaveSingleSelect(survey, questions, questionNumber = "7", rbSevenSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "7-A", rbSevenASection, false);
                SaveSingleSelect(survey, questions, questionNumber = "8", rbEightSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "8-A", rbEightASection, false);
                SaveSingleSelect(survey, questions, questionNumber = "9", rbNineSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "10", rbTenSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "11", rbElevenSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "12", rbTwelveSection, false);
                //SaveFreeText(survey, questions, questionNumber = "20", AdditionalHistoryTextBox, false);
                //SaveFreeText(survey, questions, questionNumber = "21", CurrentMedicationTextBox, false);
                //SaveFreeText(survey, questions, questionNumber = "22", PhysicalExaminationTextBox, false);
                SaveSingleSelect(survey, questions, questionNumber = "5-A", rbFiveASubsection, false);
                SaveSingleSelect(survey, questions, questionNumber = "5-B", rbFiveBSubsection, false);
                SaveSingleSelect(survey, questions, questionNumber = "5-C", rbFiveCSubsection, false);
                SaveSingleSelect(survey, questions, questionNumber = "5-D", rbFiveDSubsection, false);                
                SaveSingleSelect(survey, questions, questionNumber = "5-D-1", rbFiveDOneSubsection, false);
                    if (rbFiveDOneASection.SelectedIndex > -1)
                    {
                        SaveSingleSelect(survey, questions, questionNumber = "5-D-1-a", rbFiveDOneASection, false);
                    } 
                SaveSingleSelect(survey, questions, questionNumber = "5-D-2", rbFiveDTwoSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "5-D-3", rbFiveDThreeSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "5-D-4", rbFiveDFourSection, false);
                SaveMultiSelect(survey, questions, questionNumber = "5-D-5", BlastExplosureTypeList.Items, false);                
                SaveSingleSelect(survey, questions, questionNumber = "5-E", rbFiveESection, false);

                }             
                SaveSingleSelect(survey, questions, questionNumber = "14", rbFourteenSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "15", rbFifteenSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-A", rbSixteenASection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-B", rbSixteenBSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-C", rbSixteenCSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-D", rbSixteenDSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-E", rbSixteenESection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-F", rbSixteenFSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-G", rbSixteenGSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-H", rbSixteenHSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-I", rbSixteenISection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-J", rbSixteenJSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-K", rbSixteenKSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-L", rbSixteenLSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-M", rbSixteenMSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-N", rbSixteenNSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-O", rbSixteenOSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-P", rbSixteenPSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-Q", rbSixteenQSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-R", rbSixteenRSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-S", rbSixteenSSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-T", rbSixteenTSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-U", rbSixteenUSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "16-V", rbSixteenVSection, false);
                SaveSingleSelect(survey, questions, questionNumber = "18", rbEighteenSection, false);
                if (rbEighteenSection.SelectedIndex > 0) { 
                    SaveMultiSelect(survey, questions, questionNumber = "18-A", BodyPartsList.Items, RadioHasValue(rbEighteenSection, "0"));
                }
                SaveSingleSelect(survey, questions, questionNumber = "19", rbSectionNineteen, false);
                SaveFreeText(survey, questions, questionNumber = "20", AdditionalHistoryTextBox, false);
                SaveFreeText(survey, questions, questionNumber = "21", CurrentMedicationTextBox, false);
                SaveFreeText(survey, questions, questionNumber = "22", PhysicalExaminationTextBox, false);
                //SaveSingleSelect(survey, questions, questionNumber = "21-A", rblMedicationReconciliationPerformed, RadioHasValue(rblMedicationReconciliationPerformed, "0"));
                //if (rblMedicationReconciliationPerformed.SelectedItem != null && rblMedicationReconciliationPerformed.SelectedItem.Text.Contains("Yes"))
                //    SaveSingleSelect(survey, questions, questionNumber = "21-B", rblMedicationGiven, false);
                //else
                //    SaveFreeText(survey, questions, questionNumber = "21-C", txtNoMedicationReconciliationPerformed, false);
                SaveSingleSelect(survey, questions, questionNumber = "27", rbSectionTwentySeven, false);
                SaveSingleSelect(survey, questions, questionNumber = "28", rbSectionTwentyEight, false);
                if (rbSectionTwentyEight.SelectedIndex == 4)
                {
                    SaveFreeText(survey, questions, questionNumber = "28-A", OtherConditionsTextBox, !RadioHasValue(rbSectionTwentyEight, "5"));
                }
                SaveSingleSelect(survey, questions, questionNumber = "29", rbSectionTwentyNine, false);
                SaveSingleSelect(survey, questions, questionNumber = "29-A-1-a", rb29A1a, false);
                SaveSingleSelect(survey, questions, questionNumber = "29-A-1-b", rb29A1b, false);
                SaveSingleSelect(survey, questions, questionNumber = "29-A-1-c", rb29A1c, false);
                SaveSingleSelect(survey, questions, questionNumber = "29-A-1-d", rb29A1d, false);
                SaveSingleSelect(survey, questions, questionNumber = "29-A-1-e", rb29A1e, false);
                if (rb29A1e.SelectedIndex == 1)
                {
                    SaveFreeText(survey, questions, questionNumber = "29-A-1-e-1", OtherSymptomTextBox, false);
                }
                    SaveSingleSelect(survey, questions, questionNumber = "29-A-1-f", rb29A1f, false);
                
                if(rb29A1f.SelectedIndex==0)
                {
                    SaveFreeText(survey, questions, questionNumber = "29-A-1-f-2", OtherMedicationsTextBox, false); 
                }
                else
                {
                    SaveSingleSelect(survey, questions, questionNumber = "29-A-1-f-1", rb29A1f1, false);
                }
                SaveSingleSelect(survey, questions, questionNumber = "29-A-1-g", rb29A1g, false);
                //SaveSingleSelect(survey, questions, questionNumber = "29-A-1-h", rb29A1h, false);
                string s = string.IsNullOrEmpty(OtherTreatmentsTextBox.Text) ? "null value" : OtherTreatmentsTextBox.Text;
                if (s == OtherTreatmentsTextBox.Text)
                {
                    SaveFreeText(survey, questions, questionNumber = "29-A-1-h", OtherTreatmentsTextBox, false);
                }

                SaveSingleSelect(survey, questions, questionNumber = "29-A-1-i", rb29A1i, false);
                SaveSingleSelect(survey, questions, questionNumber = "29-A-1-j", rb29A1j, false);
                //if (ConsultRequestListBox.SelectedIndex != -1)
                //{
                if(rb29A1j.SelectedIndex>0)
                {
                    SaveMultiSelect(survey, questions, questionNumber = "29-A-1-j-1", ConsultRequestListBox.Items, false);
                }
                
                    //}  rb29A2

                SaveSingleSelect(survey, questions, questionNumber = "29-A-2", rb29A2, false);
                if(rb29A2.SelectedIndex==0)
                {
                    SaveMultiSelect(survey, questions, questionNumber = "29-A-2-a", cb29A2no.Items, false);
                }
                s = string.IsNullOrEmpty(PlanDetailsTextBox.Text) ? "null value" : PlanDetailsTextBox.Text;
                if (s == PlanDetailsTextBox.Text)
                {
                    SaveFreeText(survey, questions, questionNumber = "30", PlanDetailsTextBox, false);
                }
            }
            else
            {
                SaveSingleSelect(survey, questions, questionNumber = "27", rbSectionTwentySeven, false);
                SaveFreeText(survey, questions, questionNumber = "30", PlanDetailsTextBox, false);
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentEvaluationEntry.aspx", "100029", "SaveSurvey()" + questionNumber);
            throw;
        }
    }

    #endregion SaveSurvey

    #region SetupEvalSurvey

    private void SetupRadio(SURVEY_RESULT result, RadioButtonList radio)
    {
        radio.SelectedIndex = result.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue ? result.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.Value - 1 : -1;
    }

    private void SetupCheckbox(SURVEY_RESULT result, CheckBoxList checkBoxes)
    {
        if (result.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
            checkBoxes.Items.FindByValue(result.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.Value.ToString()).Selected = true;
    }

    private void SetUpEvalSurvey(SURVEY survey)
    {
        string question = "";
        try
        {
            foreach (var result in survey.SURVEY_RESULTs)
            {
                if (null == result.STD_QUESTION_CHOICE)
                    continue;
                question = result.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
                switch (question)
                {
                    case "A": SetupRadio(result, rbnonVAProvider); break;
                    case "1": SetupRadio(result, rbMaritalStatus); break;
                    case "2": SetupRadio(result, rbEducationalLevel); break;
                    case "3": SetupRadio(result, rbEmploymentStatus); break;
                    case "4": SetupRadio(result, rbInjuriesQuantity); break;
                    case "4-A-1": InjuryMonthTextBox.Text = result.RESULT_TEXT; break;
                    case "4-A-2": InjuryYearTextBox.Text = result.RESULT_TEXT; break;
                    case "4-B-1": SecondInjuryMonthTextBox.Text = result.RESULT_TEXT; break;
                    case "4-B-2": SecondInjuryYearTextBox.Text = result.RESULT_TEXT; break;
                    case "4-C-1": LeastInjuryMonthTextBox.Text = result.RESULT_TEXT; break;
                    case "4-C-2": LeastInjuryYearTextBox.Text = result.RESULT_TEXT; break;
                    case "5-A": SetupRadio(result, rbFiveASubsection); break;
                    case "5-B": SetupRadio(result, rbFiveBSubsection); break;
                    case "5-C": SetupRadio(result, rbFiveCSubsection); break;
                    case "5-D": SetupRadio(result, rbFiveDSubsection); break;
                    case "5-D-1": SetupRadio(result, rbFiveDOneSubsection); break;
                    case "5-D-1-a": SetupRadio(result, rbFiveDOneASection); break;
                    case "5-D-2": SetupRadio(result, rbFiveDTwoSection); break;
                    case "5-D-3": SetupRadio(result, rbFiveDThreeSection); break;
                    case "5-D-4": SetupRadio(result, rbFiveDFourSection); break;
                    case "5-D-5": SetupCheckbox(result, BlastExplosureTypeList); break;
                    case "5-E": SetupRadio(result, rbFiveESection); break;
                    case "6": SetupRadio(result, rbSixSection); break;
                    case "6-A": SetupRadio(result, rbSixASection); break;
                    case "7": SetupRadio(result, rbSevenSection); break;
                    case "7-A": SetupRadio(result, rbSevenASection); break;
                    case "8": SetupRadio(result, rbEightSection); break;
                    case "8-A": SetupRadio(result, rbEightASection); break;
                    case "9": SetupRadio(result, rbNineSection); break;
                    case "10": SetupRadio(result, rbTenSection); break;
                    case "11": SetupRadio(result, rbElevenSection); break;
                    case "12": SetupRadio(result, rbTwelveSection); break;
                    case "14": SetupRadio(result, rbFourteenSection); break;
                    case "15": SetupRadio(result, rbFifteenSection); break;
                    case "16-A": SetupRadio(result, rbSixteenASection); break;
                    case "16-B": SetupRadio(result, rbSixteenBSection); break;
                    case "16-C": SetupRadio(result, rbSixteenCSection); break;
                    case "16-D": SetupRadio(result, rbSixteenDSection); break;
                    case "16-E": SetupRadio(result, rbSixteenESection); break;
                    case "16-F": SetupRadio(result, rbSixteenFSection); break;
                    case "16-G": SetupRadio(result, rbSixteenGSection); break;
                    case "16-H": SetupRadio(result, rbSixteenHSection); break;
                    case "16-I": SetupRadio(result, rbSixteenISection); break;
                    case "16-J": SetupRadio(result, rbSixteenJSection); break;
                    case "16-K": SetupRadio(result, rbSixteenKSection); break;
                    case "16-L": SetupRadio(result, rbSixteenLSection); break;
                    case "16-M": SetupRadio(result, rbSixteenMSection); break;
                    case "16-N": SetupRadio(result, rbSixteenNSection); break;
                    case "16-O": SetupRadio(result, rbSixteenOSection); break;
                    case "16-P": SetupRadio(result, rbSixteenPSection); break;
                    case "16-Q": SetupRadio(result, rbSixteenQSection); break;
                    case "16-R": SetupRadio(result, rbSixteenRSection); break;
                    case "16-S": SetupRadio(result, rbSixteenSSection); break;
                    case "16-T": SetupRadio(result, rbSixteenTSection); break;
                    case "16-U": SetupRadio(result, rbSixteenUSection); break;
                    case "16-V": SetupRadio(result, rbSixteenVSection); break;
                    case "18": SetupRadio(result, rbEighteenSection); break;
                    case "18-A": SetupCheckbox(result, BodyPartsList); break;
                    case "19": SetupRadio(result, rbSectionNineteen); break;
                    case "20": AdditionalHistoryTextBox.Text = result.RESULT_TEXT; break;
                    case "21": CurrentMedicationTextBox.Text = result.RESULT_TEXT; break;
                   // case "21-A": SetupRadio(result, rblMedicationReconciliationPerformed); break;
                   // case "21-B": SetupRadio(result, rblMedicationGiven); break;
                   // case "21-C": txtNoMedicationReconciliationPerformed.Text = result.RESULT_TEXT; break;
                    case "22": PhysicalExaminationTextBox.Text = result.RESULT_TEXT; break;
                    case "27": SetupRadio(result, rbSectionTwentySeven); break;
                    case "28": SetupRadio(result, rbSectionTwentyEight); break;
                    case "28-A": OtherConditionsTextBox.Text = result.RESULT_TEXT; break;
                    case "29": SetupRadio(result, rbSectionTwentyNine); break;
                    
                    case "29-A-1-a": SetupRadio(result, rb29A1a); break;
                    case "29-A-1-b": SetupRadio(result, rb29A1b); break;
                    case "29-A-1-c": SetupRadio(result, rb29A1c); break;
                    case "29-A-1-d": SetupRadio(result, rb29A1d); break;
                    case "29-A-1-e": SetupRadio(result, rb29A1e); break;
                    case "29-A-1-e-1": OtherSymptomTextBox.Text = result.RESULT_TEXT; break;
                    case "29-A-1-f": SetupRadio(result, rb29A1f); break;
                    case "29-A-1-f-1": SetupRadio(result, rb29A1f1); break;
                    case "29-A-1-f-2": OtherMedicationsTextBox.Text = result.RESULT_TEXT; break;
                    case "29-A-1-g": SetupRadio(result, rb29A1g); break;
                    //case "29-A-1-h": SetupRadio(result, rb29A1h); break;
                    case "29-A-1-h": OtherTreatmentsTextBox.Text = result.RESULT_TEXT; break;
                    case "29-A-1-i": SetupRadio(result, rb29A1i); break;
                    case "29-A-1-j": SetupRadio(result, rb29A1j); break;
                    case "29-A-1-j-1": SetupCheckbox(result, ConsultRequestListBox); break;
                    case "29-A-2": SetupRadio(result, rb29A2); break;
                    case "29-A-2-a": SetupCheckbox(result, cb29A2no); break;       
                 
                    case "30": PlanDetailsTextBox.Text = result.RESULT_TEXT; break;
                }
            }
        }
        catch (Exception ex)
        {
            string functionQuestion = "SetUpEvalSurvey()" + question;
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentEvaluationEntry.aspx", "100029", functionQuestion);
        }
    }

    #endregion SetupEvalSurvey

    private void SetDefaultValues()
    {
        rbnonVAProvider.SelectedIndex = 0; //Default to NO
    }

    #endregion
}
